--
SELECT TSystem.triggers__all__enable();
--

DROP TABLE IF EXISTS TWawi.beleg_k__rechnungv CASCADE;
DROP TABLE IF EXISTS TWawi.beleg_p__rechnungvbasetxt CASCADE;
DROP TABLE IF EXISTS TWawi.beleg_p__rechnungv CASCADE;
DROP TABLE IF EXISTS TWawi.abzu_p__rechnungv CASCADE;

-- Kopf


--
CREATE TABLE TWawi.beleg_k__rechnungv --rechnungv_p
 -- alle eingerückten Felder können wahrscheinlich weg, wenn geprüft und Verwendung entsprechend umgestellt wird
 (      be_steucode2           INTEGER, -- komplett sinnlos, nur wegen Abwärtskompatibilität. Kann weg wenn Felder aus Oberfläche entfernt werden
        be_steuproz2           NUMERIC(8,4), -- siehe Feld drüber
     be_umf                 NUMERIC(8,2) DEFAULT 1,                  -- Umrechnungsfaktor - nicht mehr in Verwendung außer für SBS-Export (Buchhaltung)
     be_wabk                VARCHAR(5),                            -- Währungsabkürzung. Sinnlose Duplizierung aus wa_abkz (EUR > €). Könnte weg       
   --                   
   kx_valuta_datum          DATE DEFAULT current_date,               -- Valutadatum > siehe Google. Verwendung im Prodat unklar, prüfen und hier im Kommentar ergänzen wenn relevant
   krx_abprozent            NUMERIC(5,2),                            -- Abschlagszahlung Prozent
   kx_gewicht               NUMERIC(12,4),                           -- Gesamtgewicht der Lieferung. Hier im Beleg unklar, könnte evtl entfernt werden und durch Lieferschein aggregiert / geholt werden?
   krv_reebwert             NUMERIC(12,4),                           -- Rechnungseinbehalt gem. VOB
   krv_reebdat              DATE,                                    -- Rechnungseinbehalts-Datum (bis) (5% bis nächstes Jahr)        
   krv_edidat               DATE,                                    -- EDI-Exportdatum via APPS, Rechnungsexport an Kunde
   kx_buchdat               DATE,                                    -- Beleg ist an die Buchhaltungsschnittstelle übergeben (analog eingangerechnung)
   kx_buchmonth             VARCHAR(6),                              -- Buchungsmonat für Buchhaltung YYYYMM (Andersrum als Eingangsrechnung)
   --                   
   krv_sta                  SMALLINT,                                -- Unklar. Status - keine interne Verwendung. Evtl irgendwas Buchhaltung Schweiz?
   krv_invckn_edi           INTEGER,                                 -- LOLL: Fortlaufende Nummer für EDI an Airbus
   --
   kx_ad_krzl               VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE,  -- Lieferadresse
   kx_ad_krz_standort       VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE   -- Standort             
 )
 INHERITS (twawi.beleg_k, TSystem_Wawi.beleg_x__allgfields, TSystem_Wawi.beleg_k__export_zoll, TSystem_Wawi.beleg_k__mahnung);
 --
-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_k__trigger__all__create('twawi','beleg_k__rechnungv');
 SELECT  TSystem_Wawi.beleg_k__constraints__all__create('twawi','beleg_k__rechnungv');
 CREATE UNIQUE INDEX beleg_k__rechnungv__k_nummer__unique ON twawi.beleg_k__rechnungv(k_nummer); -- Jede Belegnummer aktuell nur einmal? > altes System JOINT nur auf belegnummer, nicht auf Code (Auch Abzuschläge)
 ALTER TABLE twawi.beleg_k__rechnungv ADD CONSTRAINT beleg_k__rechnungv__abzu_only_prof__tp CHECK (CASE WHEN krx_abprozent IS NOT NULL THEN k_code IN ('P', 'T') ELSE true END); -- Abzuschlag nur in Belegtyp 'T', 'P' (Teilrechnung, Proforma) 
-- Trigger
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__rechnungv__a_700_iu__definitiv__lfs() RETURNS TRIGGER AS $$
  BEGIN
   IF TSystem.Settings__GetBool('LieferscheinWADatumPerDefinitivRechnung') THEN -- Warenausgangsdatum vom Lieferschein spätestens dann setzen, wenn Rechnung definitiv wird. Oder nur manuell.
         UPDATE TWawi.beleg_p__lieferscheinv SET plv_datum_warenausgang = current_date
         FROM  TWawi.beleg_k__rechnungv rk
         WHERE plv_datum_warenausgang IS NULL
           AND p_id = prv_lieferscheinv_p_id
           AND rk.k_id = new.p_k_id;
   END IF;
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER a_700_iu__rechnungv__definitiv__lfs
   AFTER INSERT OR UPDATE
   OF k_definitiv
   ON TWawi.beleg_k__rechnungv
   FOR EACH ROW
   WHEN (new.k_definitiv)
   EXECUTE PROCEDURE TWawi.beleg_k__rechnungv__a_700_iu__definitiv__lfs();
 -- 
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__rechnungv__b_410_iu__wert__abprozent() RETURNS TRIGGER AS $$ --
  DECLARE abprozent NUMERIC; 
  BEGIN
    abprozent := COALESCE(new.krx_abprozent / 100, 1);
    --
    new.k_wert_tot_netto             := new.k_wert_tot_netto            * abprozent;
    new.k_wert_tot_netto_gwaer       := new.k_wert_tot_netto_gwaer      * abprozent;
    new.k_wert_tot_brutto            := new.k_wert_tot_brutto           * abprozent;
    new.k_wert_tot_brutto_gwaer      := new.k_wert_tot_brutto_gwaer     * abprozent;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql; 
  --
  CREATE TRIGGER b_410_iu__rechnungv__wert__abprozent
   BEFORE INSERT OR UPDATE
   OF krx_abprozent, k_wert_netto, k_wert_abzu_netto, k_wert_abzuk_netto
   ON TWawi.beleg_k__rechnungv
   FOR EACH ROW
   WHEN (new.krx_abprozent IS NOT NULL)
   EXECUTE PROCEDURE TWawi.beleg_k__rechnungv__b_410_iu__wert__abprozent();
  --
 
 
 --
--
CREATE OR REPLACE FUNCTION TWawi.beleg_k__rechnungv__b_050_i__texte_zoll() RETURNS TRIGGER AS $$
  DECLARE krz VARCHAR;
          spco VARCHAR;
          export BOOLEAN;
          euexport BOOLEAN;
          ursprungtxt BOOLEAN;
          adktxtexport TEXT;
          adktxtexportrtf TEXT;
          adktxtursprung TEXT;
          adktxtursprungrtf TEXT;
  BEGIN
    SELECT ad_krz, a1_export, a1_euexport, a1_ursprungstxt,
           a1_export_adktxt, a1_export_adktxt_rtf,
           a1_ursprungstxt_adktxt, a1_ursprungstxt_adktxt_rtf
      INTO krz, export, euexport, ursprungtxt,
           adktxtexport, adktxtexportrtf,
           adktxtursprung, adktxtursprungrtf
      FROM adressen_view JOIN adk1 ON a1_krz = adk_ad_krz WHERE ad_krz = new.k_ad_krz;
    --
    spco := prodat_languages.adk1_spco(krz);
    --
    IF new.k_zoll_export_txt IS NULL THEN
        IF adktxtexport IS NOT NULL THEN --Kundenspezifischer Exporttxt
            new.k_zoll_export_txt       := adktxtexport;
            new.k_zoll_export_txt_rtf   := adktxtexportrtf;
        ELSIF export THEN                --StandardExportTxt aus Bemerkungsverwaltung
            SELECT txt, txtrtf INTO new.k_zoll_export_txt, new.k_zoll_export_txt_rtf FROM belarzu__zu_tit__gettxtrtf('EXPORT-INT', spco);
        ELSIF euexport THEN              --
            SELECT txt, txtrtf INTO new.k_zoll_export_txt, new.k_zoll_export_txt_rtf FROM belarzu__zu_tit__gettxtrtf('EXPORT-EU', spco);
        END IF;
    END IF;
    --
    IF new.k_zoll_ursprungs_txt IS NULL THEN
        IF adktxtursprung IS NOT NULL THEN
            new.k_zoll_ursprungs_txt        := adktxtursprung;
            new.k_zoll_ursprungs_txt_rtf    := adktxtursprungrtf;
        ELSIF ursprungtxt THEN--noch kein Text vorhanden (Proformarechnung)
            SELECT txt, txtrtf INTO new.k_zoll_ursprungs_txt, new.k_zoll_ursprungs_txt_rtf FROM belarzu__zu_tit__gettxtrtf('EXPORT-URSPRUNG', spco);
        END IF;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER b_050_i__rechnungv__texte_zoll
   BEFORE INSERT
   ON TWawi.beleg_k__rechnungv
   FOR EACH ROW
   EXECUTE PROCEDURE TWawi.beleg_k__rechnungv__b_050_i__texte_zoll();
 
 -- TODO
/* TODO
CREATE OR REPLACE FUNCTION belkopf__a_iu_keywordsearch() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM TSystem.kws_create_keywords(new.*);
   RETURN new;
  END $$ LANGUAGE plpgsql;
  
  CREATE TRIGGER belkopf__a_iu_keywordsearch
   AFTER INSERT OR UPDATE
    OF be_bnr
   ON belkopf
   FOR EACH ROW
   EXECUTE PROCEDURE belkopf__a_iu_keywordsearch();   
 --
 
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow belkopf) RETURNS VOID AS $$
  DECLARE r RECORD;
          keytable VARCHAR;
          keydbrid VARCHAR;
  BEGIN
    keytable:='belkopf';
    keydbrid:=src_dataRow.dbrid;
    DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
    --
    PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.be_bnr,  'be_bnr', keydbrid);
    
    RETURN;
  END $$ LANGUAGE plpgsql;   
*/
--
 
-- Position

CREATE TABLE twawi.beleg_p__rechnungvbasetxt -- Basis Tabelle alle Positionen sowie nur Textpositionen
 (
 )INHERITS (TSystem_wawi.beleg_p);
 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('twawi','beleg_p__rechnungvbasetxt', 'twawi','beleg_k__rechnungv');
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('twawi','beleg_p__rechnungvbasetxt');
--
CREATE TABLE twawi.beleg_p__rechnungv
 ( prv_verkauf_p_id                 INTEGER REFERENCES auftg,   -- Bezug zur Vorgänger-Position im Verkauf
   prv_verkauf_k_nummer             VARCHAR(30),    -- bz_auftg
   prv_verkauf_p_pos                INTEGER,        -- bz_auftgpos
   prv_verkauf_p_parent_pos         INTEGER,        -- bz_auftghpos
   prv_verkauf_add_nummer_pos       VARCHAR(200),   -- für Index für Abschlagsrechnungen
   --
   prv_lieferscheinv_k_nummer       VARCHAR(30),    -- bz_lfs
   prv_lieferscheinv_p_id           INTEGER,        -- bz_belp_id --constraints:  REFERENCES belegpos ON UPDATE CASCADE
   --
   prv_gutschrift_k_nummer          VARCHAR(15), -- Bezug zu Rechnungsposition, z.B. Originalrechung bei Gutschrift aus Rechnung
   prv_gutschrift_p_pos             SMALLINT,    
   --  
     bz_vkp_brutto       NUMERIC(16,4),                         -- Für Eingabe bei Kasse. Oberfläche rechnet Brutto -> Netto zurück. Kann Wahrscheinlich weg.     
   --       
   bz_buchdat          DATE,                                    -- Datum Übergabe Buchhaltung Aufteilungsbuchungen
   bz_buchdone         BOOL DEFAULT FALSE       
 )
 INHERITS (twawi.beleg_p__rechnungvbasetxt, TSystem_Wawi.beleg_p__art_frei, twawi.beleg_p);    

-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('twawi','beleg_p__rechnungv', 'twawi','beleg_k__rechnungv');
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('twawi','beleg_p__rechnungv');
 ALTER TABLE twawi.beleg_p__rechnungv ALTER COLUMN p_k_code SET NOT NULL; -- Beachte Trigger beleg_p__b_010_iu__p_nummer
-- Indizes    
 CREATE INDEX beleg_p__rechnungv__bz_buchdone                ON twawi.beleg_p__rechnungv(bz_buchdone) WHERE NOT bz_buchdone; -- Todo notwendig?
 CREATE INDEX beleg_p__rechnungv__lieferscheinv_p_id         ON twawi.beleg_p__rechnungv(prv_lieferscheinv_p_id) WHERE prv_lieferscheinv_p_id IS NOT NULL;
 CREATE INDEX beleg_p__rechnungv__lieferscheinv_nummer       ON twawi.beleg_p__rechnungv(prv_lieferscheinv_k_nummer) WHERE prv_lieferscheinv_k_nummer IS NOT NULL;
 CREATE INDEX beleg_p__rechnungv__auftg                      ON twawi.beleg_p__rechnungv(prv_verkauf_k_nummer, prv_verkauf_p_pos) WHERE prv_verkauf_k_nummer IS NOT NULL;
 CREATE INDEX beleg_p__rechnungv__add_auftg_pos              ON twawi.beleg_p__rechnungv(prv_verkauf_add_nummer_pos) WHERE prv_verkauf_add_nummer_pos IS NOT NULL;
 CREATE INDEX beleg_p__rechnungv__add_auftg_pos_func         ON twawi.beleg_p__rechnungv(belzeil_add_auftg_pos(prv_verkauf_k_nummer, prv_verkauf_p_pos)) WHERE prv_verkauf_add_nummer_pos IS NOT NULL;

-- Trigger
 -- 
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__b_iu_300__verkauf_pos() RETURNS TRIGGER AS $$ --evtl für Werteberechnungen schon nötig
  DECLARE 
       ragnr         VARCHAR;
       ragpos        INTEGER;
  BEGIN
   new.prv_verkauf_p_id := ag_id FROM auftg WHERE ag_astat = 'E' AND ag_nr = new.prv_verkauf_k_nummer AND ag_pos = new.prv_verkauf_p_pos;
   -- Anzahlung auf Rahmen?
   SELECT ag_nr, ag_pos INTO ragnr, ragpos FROM auftg WHERE ag_id=(SELECT ag_rahmen_ag_id FROM auftg WHERE ag_nr = new.prv_verkauf_k_nummer AND ag_pos = new.prv_verkauf_p_pos AND ag_astat = 'E');
   --
   new.prv_verkauf_add_nummer_pos := belzeil_add_auftg_pos(COALESCE(ragnr, new.prv_verkauf_k_nummer), COALESCE(ragpos, new.prv_verkauf_p_pos));
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER b_300_iu__rechnungv__verkauf_pos
   BEFORE INSERT OR UPDATE
   OF prv_verkauf_k_nummer, prv_verkauf_p_pos
   ON TWawi.beleg_p__rechnungv
   FOR EACH ROW
   EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__b_iu_300__verkauf_pos();
 -- Lieferscheinzugehörigkeit
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__b_iu_500__lieferscheinv_p_id() RETURNS TRIGGER AS $$
  BEGIN
   -- Änderung Lieferschein-Vorgänger (old.bz_belp_id IS DISTINCT FROM new.bz_belp_id)
   new.prv_lieferscheinv_k_nummer := p_k_nummer FROM TWawi.beleg_p__lieferscheinv WHERE p_id = new.prv_lieferscheinv_p_id;
   RETURN new;
  END $$ LANGUAGE plpgsql;
   
  CREATE TRIGGER b_500_iu__rechnungv__lieferscheinv_p_id
   BEFORE INSERT OR UPDATE
   OF prv_lieferscheinv_p_id
   ON twawi.beleg_p__rechnungv
   FOR EACH ROW
   EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__b_iu_500__lieferscheinv_p_id();

 -- #9555 PHKO löschen von eintrag im Zahlungsplan 
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__a_d_700__verkauf_zahlplan_reset() RETURNS TRIGGER AS $$
   BEGIN
     UPDATE auftgdokzahlplan SET azp_be_bnr = NULL WHERE azp_be_bnr = old.p_k_nummer;
     RETURN old;
   END $$ LANGUAGE plpgsql;
   
   CREATE TRIGGER a_700_d__rechnungv__zahlplan_reset
     AFTER DELETE 
     ON twawi.beleg_p__rechnungv
     FOR EACH ROW
     EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__a_d_700__verkauf_zahlplan_reset();
 
 
 
 -- Aufteilungsbuchungen
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__a_700_iu__auftgbuch() RETURNS TRIGGER AS $$
  DECLARE stkf NUMERIC;
  BEGIN
     IF (new.p_k_code = 'R') THEN --Aufteilungsbuchung
        -- TODO PERFORM tplanterm.buchfak_auftbuch_art(new.p_id);--Aufteilungsbuchung erstellen
     END IF;        
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;  
  --
  CREATE TRIGGER a_700_iu__rechnungv__auftgbuch
    AFTER INSERT OR UPDATE
    -- OF ??
    ON TWawi.beleg_p__rechnungv
    FOR EACH ROW
    EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__a_700_iu__auftgbuch();
 
 -- Automatische Löschung des Lagerabgangs bei Rechnung im vereinfachten Konsignationsprozess, siehe #8093.
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__a_600_d__konsignationslager() RETURNS TRIGGER AS $$
  BEGIN
    -- WHEN (old.bz_belp_id IS NOT NULL) -- LFS vorhanden
    
    -- Funktionalität nicht aktiv, dann raus
    IF NOT TSystem.Settings__GetBool('EntnahmeVomKonsiLiefsch') THEN
            RETURN old;
     END IF;
    
    -- Nur mit Lieferscheinen mit Status K arbeiten.
    IF EXISTS(SELECT true FROM TWawi.beleg_p__lieferscheinv WHERE p_id = old.prv_lieferscheinv_p_id AND 'K' IN (p_bstat1, p_bstat2, p_bstat3)) THEN
        IF (SELECT count(*) FROM lifsch WHERE l_belp_id = old.prv_lieferscheinv_p_id) > 1 THEN
            PERFORM PRODAT_MESSAGE(
                lang_text(16652) || E'\n\n' || lang_text(527) || ': ' ||
                    (SELECT p_k_nummer || ', ' || lang_text(164) || ': ' || p_pos FROM TWawi.beleg_p__lieferscheinv WHERE p_id = old.prv_lieferscheinv_p_id) 
                , 'Warning'); -- Warnung, dass nicht mehrere LA auf Konsi-LFS verarbeitet werden können, inkl. Ausgabe schuldiger LFS-Pos.
        ELSE
            DELETE FROM lifsch WHERE l_bz_id = old.p_id; -- Löschen führt automatisch zu Lagerzugang
        END IF;
     END IF;
    
    RETURN old;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER a_600_d__rechnungv__konsignationslager
    AFTER DELETE
    ON TWawi.beleg_p__rechnungv
    FOR EACH ROW
    WHEN (old.prv_lieferscheinv_p_id IS NOT NULL) -- LFS vorhanden
    EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__a_600_d__konsignationslager();
 -- Automatische Anlage/Korrektur von Lagerabgang bei Rechnung im vereinfachten Konsignationsprozess, siehe #8093.
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__a_600_iu__konsignationslager() RETURNS TRIGGER AS $$
  BEGIN
    -- WHEN (new.bz_belp_id IS NOT NULL) -- LFS vorhanden
    
    -- Funktionalität nicht aktiv, dann raus
    IF NOT TSystem.Settings__GetBool('EntnahmeVomKonsiLiefsch') THEN
        RETURN new;
     END IF;
    
    -- Nur mit Lieferscheinen mit Status K arbeiten.
    IF EXISTS(SELECT true FROM TWawi.beleg_p__lieferscheinv WHERE p_id = new.prv_lieferscheinv_p_id AND 'K' IN (p_bstat1, p_bstat2, p_bstat3)) THEN
        -- Nicht abgebildet: ggf. mehrere LA mit untersch. Chargen auf Konsi-Auftrag zu Konsi-LFS
        -- Auftrag => m LA1 (umbuch) mit untersch. Chargen => n LFS-Pos => n=k RECH-Pos => m(n)=l LA2 (auto)
        IF (SELECT count(*) FROM lifsch WHERE l_belp_id = new.prv_lieferscheinv_p_id) > 1 THEN
            PERFORM PRODAT_MESSAGE(
                lang_text(16652) || E'\n\n' || lang_text(527) || ': ' ||
                    (SELECT p_k_nummer || ', ' || lang_text(164) || ': ' || p_pos FROM TWawi.beleg_p__lieferscheinv WHERE p_id = new.prv_lieferscheinv_p_id) 
                , 'Warning'); -- Warnung, dass nicht mehrere LA auf Konsi-LFS verarbeitet werden können, inkl. Ausgabe schuldiger LFS-Pos.
         ELSE -- Automatischer LA
            IF TG_OP = 'INSERT' THEN
                INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_ag_id, l_lgort, l_lgchnr, l_aknr, l_abg_mec, l_abgg, l_inliefdok, l_bz_id)
                SELECT beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, belp_ag_id, konsi_lifsch.l_lgort_ue, konsi_lifsch.l_lgchnr, new.p_aknr, new.p_me, new.p_menge, true, new.p_id
                FROM lieferschein_pos
                  JOIN lieferschein ON beld_id = belp_dokument_id
                  JOIN lifsch AS konsi_lifsch ON konsi_lifsch.l_belp_id = belp_id -- mehrere LA auf LFS möglich
                WHERE belp_id = new.prv_lieferscheinv_p_id;
            
             ELSE -- UPDATE
                IF new.p_menge_gme IS DISTINCT FROM old.p_menge_gme THEN -- Menge hat sich geändert
                    UPDATE lifsch SET
                      l_abg_mec = new.p_me,
                      l_abgg    = new.p_menge
                    WHERE l_bz_id = new.p_id;
                END IF;
             END IF;
         END IF;
    END IF;
    
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER a_600_iu__rechnungv__konsignationslager
    AFTER INSERT OR UPDATE
    OF p_menge, p_me, p_menge_gme
    ON TWawi.beleg_p__rechnungv
    FOR EACH ROW
    WHEN (new.prv_lieferscheinv_p_id IS NOT NULL) -- LFS vorhanden
    EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__a_600_iu__konsignationslager();
 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__b_010_iu__p_nummer() RETURNS TRIGGER AS $$
  BEGIN
   -- KOMPATBILITÄT alte BelKopf
   IF new.p_tablename LIKE 'rechnungv%' AND new.p_k_code IS NULL THEN
      new.p_k_code := k_code FROM TWawi.beleg_k__rechnungv WHERE k_nummer = new.p_k_nummer; --Bei den alten Strukturen MUSSS k_nummer (ohne code) unique sein! Kann später umgebaut werden
   END IF;
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;        
  --
  CREATE TRIGGER b_010_iu__p_nummer
    BEFORE INSERT OR UPDATE
    ON twawi.beleg_p__rechnungv
    FOR EACH ROW
    WHEN (new.p_k_nummer IS NOT NULL AND new.p_k_code IS NULL) --
    EXECUTE PROCEDURE TWawi.beleg_p__rechnungv__b_010_iu__p_nummer();        
    
--
-- TODO: belzeil_get_auftgmainpos Haupt/Unterpositionen
-- Abzuschläge

--
CREATE TABLE twawi.abzu_p__rechnungv  --TRIGGER rechnungv__abzu__b_01_iu__k_nummer
 (
  azv_k_nummer          VARCHAR(30) NOT NULL REFERENCES twawi.beleg_k__rechnungv(k_nummer) ON DELETE CASCADE,
  azv_verkauf_k_nummer  VARCHAR(30),    -- Stammt aus diesem Auftrag und ...  (Obsolet wegen source_dbrid?)
  azv_verkauf_p_pos     SMALLINT,       -- dieser Auftragsposition            (Obsolet wegen source_dbrid?)
  azv_p_rechnungv_p_pos INTEGER        -- Abzuschlag bezieht sich auf diese Rechn.Pos. (muss in Listen beruecksichtigt werden damit nicht zweimal verrechnet bei Teillieferung)
 
 ) INHERITS (TWawi.abzu_p);
-- Constraints und Trigger
 SELECT TSystem_Wawi.abzu_p__constraints__all__create('twawi.abzu_p__rechnungv', 'twawi.beleg_k__rechnungv', 'twawi.beleg_p__rechnungv');
 SELECT TSystem_Wawi.abzu_p__trigger__all__create('twawi','abzu_p__rechnungv', 'twawi','beleg_p__rechnungv');
CREATE INDEX abzu__rechnungv__azv_k_nummer ON twawi.abzu_p__rechnungv(azv_k_nummer);
 
-- Trigger;     ---      Kompatibilität alte Struktur BE_BNR + BE_POS, abzu_src_done usw.
 CREATE OR REPLACE FUNCTION twawi.abzu_p__rechnungv__b_010_iu__k_nummer() RETURNS TRIGGER AS $$
   BEGIN
    new.az_k_id := k_id FROM twawi.beleg_k__rechnungv WHERE k_nummer = new.azv_k_nummer;
    --
    IF new.azv_p_rechnungv_p_pos IS NOT NULL THEN -- Positionsbezogen
       new.az_p_id := p_id FROM twawi.beleg_p__rechnungv WHERE p_k_nummer = new.azv_k_nummer AND p_pos = new.azv_p_rechnungv_p_pos;
    ELSE -- Kopfbezogen                
       new.az_p_id := NULL;
    END IF;
    --
    IF new.az_k_id IS NULL AND new.az_p_id IS NULL THEN
       RAISE EXCEPTION 'abzu_p__rechnungv__b_01_iu__k_nummer : kopf and pos not found for : "%" Pos: %',  new.azv_k_nummer, new.azv_p_rechnungv_p_pos;
    END IF;
    --
    RETURN new;
   END $$ LANGUAGE plpgsql;  
   
   CREATE TRIGGER b_010_iu__rechnungv__k_nummer
     BEFORE INSERT OR UPDATE
     OF azv_k_nummer, azv_p_rechnungv_p_pos
     ON twawi.abzu_p__rechnungv
     FOR EACH ROW
     EXECUTE PROCEDURE twawi.abzu_p__rechnungv__b_010_iu__k_nummer();
 
 CREATE OR REPLACE FUNCTION twawi.abzu_p__rechnungv__b_011_iu__beazbnr() RETURNS TRIGGER AS $$
   BEGIN    
    IF new.az_k_id IS NOT NULL THEN
       new.azv_k_nummer := k_nummer FROM TSystem_Wawi.beleg_k WHERE k_id = new.az_k_id;
     ELSIF new.az_p_id IS NOT NULL THEN
       new.azv_k_nummer := k_nummer FROM TSystem_Wawi.beleg_p WHERE p_id = new.az_p_id;
     END IF;
    --
    IF new.azv_k_nummer IS NULL THEN
       RAISE EXCEPTION 'abzu_p__rechnungv__b_011_iu__beazbnr : azv_k_nummer/beaz_bebnr IS NULL : az_id:"%"',  new.az_id;
    END IF;
    --
    RETURN new;
   END $$ LANGUAGE plpgsql;  
   
   CREATE TRIGGER b_011_iu__rechnungv__beazbnr
     BEFORE INSERT OR UPDATE
     ON twawi.abzu_p__rechnungv
     FOR EACH ROW
     WHEN (new.azv_k_nummer IS NULL)
     EXECUTE PROCEDURE twawi.abzu_p__rechnungv__b_011_iu__beazbnr(); 
--
    
-- Views
/* -- TODO Update
--
CREATE VIEW z_99_deprecated.belkopf AS (
 SELECT
  k_id_oldstructure,
  --k_id, geht nicht, da es mit kopiert würde  ?????????
  k_nummer                       AS be_bnr,
  k_code                         AS be_prof,
  k_kba_key                      AS be_txba,
  k_ad_krz                       AS be_rkrz, 
  k_titel                        AS be_titel,
  k_erfasst_datum                AS be_bdat,
  
  k_definitiv                    AS be_def,
  
  k_txt_anschr                   AS be_bem1,
  k_txt_anschr_rtf               AS be_bem1_rtf,
  k_txt_schluss                  AS be_bem2,
  k_txt_schluss_rtf              AS be_bem2_rtf,  
  k_zoll_export_txt              AS be_txtexp,
  k_zoll_export_txt_rtf          AS be_txtexp_rtf,
  k_zoll_ursprungs_txt           AS be_txtexpurspr,
  k_zoll_ursprungs_txt_rtf       AS be_txtexpurspr_rtf,
  k_versand_bem                     AS be_vers,  
  
  k_apext_ap_krzl                AS be_apkrzl,
  k_apext                        AS be_ap,
  k_apint_db_usename1            AS be_apint,
  k_pruef_db_usename1            AS be_pruefer,
  k_pruef_freigabe1              AS be_freigabe,  
 
  k_waer                         AS be_waco,
  k_waer_kurs                    AS be_umr,
  k_rund_faktor                  AS be_rund,
  k_spco                         AS be_spco,
  k_steu_code                    AS be_steucode1,        
  k_steu_proz                    AS be_steuproz1,        
  
  k_zak_skonto_verf_d            AS be_skv,
  k_zak_skonto_proz              AS be_sks,
  k_zak_zahlziel_d               AS be_zak,
  k_zak_zahlart_za_id            AS be_zahlart, 
  k_zak_bem                      AS be_kond,
  k_zak_kto_name                 AS be_ktv_name,  
  k_zak_zahlung_erledigt         AS be_zahl_erledigt,
  
  k_wert_tot_netto               AS be_gesamt_net,       -- Belegsumme
  k_wert_tot_netto_gwaer         AS be_gesamt_net_basis_w,
  k_wert_tot_brutto              AS be_gesamt_steu,       -- Belegsumme nach Steuern
  k_wert_tot_brutto_gwaer        AS be_gesamt_steu_basis_w,
  
  k_mahn_stufe                   AS be_ms,
  k_mahn_sperre                  AS be_mahnsperr,
  k_mahn_erfasst_datum           AS be_mahnd,
  
  x_allgv1                       AS be_allg1,
  x_allgv2                       AS be_allg2,
  x_allgv3                       AS be_allg3,
  x_allgn1                       AS be_allnr1,
  x_allgn2                       AS be_allnr2,
  x_allgn3                       AS be_allnr3,
  
  kx_valuta_datum                AS be_valuta,           
  krx_abprozent                  AS be_abprozent,        
  krv_sta                        AS be_sta,              
  kx_gewicht                     AS be_gew,              
  krv_reebwert                   AS be_reeb,             
  krv_reebdat                    AS be_rebd,             
  krv_edidat                     AS be_edidat,           
  kx_buchdat                     AS be_buchdat,          
  kx_buchmonth                   AS be_buchmonth,        
  krv_invckn_edi                 AS be_invckn_edi,
  
    be_umf,
    be_steucode2,        
    be_steuproz2,        
    be_wabk,

  kx_ad_krzl                     AS be_liefkrz,          
  kx_ad_krz_standort             AS be_sortkrz,          

  --
     
  dbrid,
  insert_date,
  insert_by,
  modified_date,
  modified_by
   
 FROM
  twawi.beleg_k__rechnungv 
 );
--
CREATE OR REPLACE VIEW z_99_deprecated.belzeil AS --NextPos usw.
 SELECT
  p_id_oldstructure,
  p_k_id,
  p_id                       AS bz_id,
  p_k_nummer                 AS bz_be_bnr,
  p_pos                      AS bz_pos,
  p_pos_strukturpos          AS bz_hwpos,
  p_txt                      AS bz_zubez,
  p_txt_rtf                  AS bz_zubez_rtf,
  
  dbrid,
  insert_date,
  insert_by,
  modified_date,
  modified_by  
 FROM
  twawi.beleg_p__rechnungvbasetxt;   
CREATE OR REPLACE VIEW z_99_deprecated.belzeil_grund AS (
 SELECT
  p_id_oldstructure,
  p_k_id,
  p_id                       AS bz_id,
  p_k_nummer                 AS bz_be_bnr,
  p_pos                      AS bz_pos,
  p_pos_strukturpos          AS bz_hwpos,
  p_txt                      AS bz_zubez,
  p_txt_rtf                  AS bz_zubez_rtf, 
  
  p_aknr_frei                AS bz_aknr,
  p_ak_bez                   AS bz_akbz,
  p_menge                    AS bz_fakt,
  p_menge_gme                AS bz_fakt_uf1,
  p_me                       AS bz_mce,
  
  p_me_bez                   AS bz_mcbez,
  
  p_preis_in_pe              AS bz_preis,
  p_preis_pe                 AS bz_preiseinheit,
  p_preis                    AS bz_vkp,
  p_rabatt                   AS bz_arab,
  p_rabatt_gesamt            AS bz_gesrab,
  p_rabatt_hint              AS bz_rabhint,
  p_rabatt_able              AS bz_canrabatt,
 
  p_preis_rabattiert         AS bz_ep_netto,
  p_preis_gme                AS bz_vkp_uf1,
  p_preis_gwaer              AS bz_vkp_basis_w,
  p_preis_gme_gwaer          AS bz_vkp_uf1_basis_w,
  p_preis_me                 AS bz_vkp_mce,
  p_preis_sumsubpos          AS bz_vkptotalpos,
   
  p_steu_code                AS bz_steucode,
  p_steu_proz                AS bz_steuproz, 
  p_konto_erloes             AS bz_zeko,
 
  p_wert_tot_netto           AS bz_tot,
  p_wert_tot_netto_gwaer     AS bz_tot_basis_w,
  p_wert_tot_brutto          AS bz_tot_steu,
  p_wert_tot_brutto_gwaer    AS bz_tot_steu_basis_w,
  
  px_an_nr                   AS bz_an_nr,
  p_ks                       AS bz_ks,
  p_adress_referenz_nummer   AS bz_bda,
  p_ak_vkpbas                AS bz_vkpbas,
  
  prv_verkauf_k_nummer       AS bz_auftg,            
  prv_verkauf_p_pos          AS bz_auftgpos,
  prv_verkauf_p_parent_pos   AS bz_auftghpos,
  prv_verkauf_add_nummer_pos AS bz_add_auftg_pos,

  prv_lieferscheinv_k_nummer AS bz_lfs,              
  prv_lieferscheinv_p_id     AS bz_belp_id,
  prv_verkauf_p_id           AS bz_ag_id,
  prv_gutschrift_k_nummer    AS bz_bz_be_bnr,        
  prv_gutschrift_p_pos       AS bz_bz_pos,           

  --
  
  dbrid,
  insert_date,
  insert_by,
  modified_date,
  modified_by,                  
  --
   bz_vkp_brutto,
   bz_buchdat,          
   bz_buchdone
   
   
 FROM
  twawi.beleg_p__rechnungv
 ); 
 
 --
 --
 --  -- bz_lagabgid_obsolet         INTEGER REFERENCES lifsch ON UPDATE CASCADE ON DELETE SET NULL, -- altes Feld konsistent halten, aber nicht restriktiv  
 --  bz_uf               NUMERIC(12,4),
 --  bz_ab_ix            INTEGER, --Index zur Nachkalkulation wegen Aufteilungsbuchungen
 -- 
 
CREATE OR REPLACE VIEW z_99_deprecated.belzeil_auftg_lif AS SELECT * FROM z_99_deprecated.belzeil_grund WHERE bz_belp_id IS NOT NULL OR bz_ag_id IS NOT NULL; -- Aus Auftrag / Lieferschein
CREATE OR REPLACE VIEW z_99_deprecated.belzeil_frei AS SELECT * FROM z_99_deprecated.belzeil_grund WHERE bz_belp_id IS NULL AND bz_ag_id IS NULL; -- freie Belegzeilen
CREATE OR REPLACE VIEW z_99_deprecated.belzeil_txt AS  -- nur Texte
 SELECT
  p_id_oldstructure,
  p_k_id,
  p_id                       AS bz_id,
  p_k_nummer                 AS bz_be_bnr,
  p_pos                      AS bz_pos,
  p_pos_strukturpos          AS bz_hwpos,
  p_txt                      AS bz_zubez,
  p_txt_rtf                  AS bz_zubez_rtf,
  
  dbrid,
  insert_date,
  insert_by,
  modified_date,
  modified_by  
 FROM
  ONLY twawi.beleg_p__rechnungvbasetxt; 
-- 
CREATE OR REPLACE VIEW z_99_deprecated.belabzu AS (
 SELECT
  az_id_oldstructure,
  az_id                   AS beaz_id,
  az_type                 AS beaz_type,
  az_visible              AS beaz_visible,
  
  azv_k_nummer            AS beaz_bebnr,
  azv_verkauf_k_nummer    AS beaz_agnr,
  azv_verkauf_p_pos       AS beaz_agpos,
  azv_p_rechnungv_p_pos   AS beaz_belpos,  
  
  az_pos                  AS beaz_pos, 
  az_abz_id               AS beaz_abz_id,
  az_anzahl               AS beaz_anz,
  az_preis                AS beaz_abzubetrag,
  az_preis_prozentual     AS beaz_abzuproz,
  
  az_steu_code            AS beaz_steu,
  az_steu_proz            AS beaz_steuproz,
  
  az_canskonto            AS beaz_canSkonto,
  az_konto                AS beaz_konto,
 
  az_txt                  AS beaz_zutxt,
  az_txt_rtf              AS beaz_zutxt_rtf,
  az_txt_int              AS beaz_zutxt_int,
 
  az_wert_netto           AS beaz_tot,
  az_wert_netto_gwaer     AS beaz_tot_basis_w,
  az_wert_brutto          AS beaz_tot_steu,
  az_wert_brutto_gwaer    AS beaz_tot_steu_basis_w,
  
  az_source_table         AS beaz_source_table,
  az_source_dbrid         AS beaz_source_dbrid,
  
  --
  dbrid,
  insert_date,
  insert_by,
  modified_date,
  modified_by
  
 FROM
  twawi.abzu_p__rechnungv
 );
--
*/
